<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Frontend;

use BorlabsCookie\Cookie\API;
use BorlabsCookie\Cookie\Config;
use BorlabsCookie\Cookie\Multilanguage;

class Frontend
{
    private static $instance;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    public function __construct()
    {
        add_action('init', [$this, 'init']);
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    /**
     * init function.
     *
     * @access public
     * @return void
     */
    public function init()
    {
        if (Config::getInstance()->get('cookieActivated') == 'yes') {

            /* Load textdomain */
            $this->loadTextdomain();

            // Handle API requests
            add_filter('query_vars', [API::getInstance(), 'addVars'], 0);
            add_filter('parse_request', [API::getInstance(), 'detectRequests'], 0);

            /* Add scripts */
            add_action('wp_enqueue_scripts', [Style::getInstance(), 'register']);
            add_action('wp_footer', [JavaScript::getInstance(), 'register']);
            add_action('wp_footer', [$this, 'insertCookieMessageBox']);

            add_filter('the_content', [ContentBlocker::getInstance(), 'detectIframes'], 100, 1);
            add_filter('embed_oembed_html', [ContentBlocker::getInstance(), 'handleOembed'], 100, 4);
            add_filter('widget_custom_html_content', [ContentBlocker::getInstance(), 'detectIframes'], 100, 1);
            add_filter('acf/format_value/type=oembed', [ContentBlocker::getInstance(), 'handleACFOembed'], 100, 3);
            add_filter('acf/format_value/type=textarea', [ContentBlocker::getInstance(), 'detectIframes'], 100, 3);
            add_filter('acf_the_content', [ContentBlocker::getInstance(), 'detectIframes'], 100, 3);

            /* Register shortcodes */
            add_shortcode('borlabs_cookie', [Shortcode::getInstance(), 'shortcodeForCookieSelectionBox']);
            add_shortcode('borlabs_cookie_log', [Shortcode::getInstance(), 'shortcodeForCookieLog']);
            add_shortcode('borlabs_cookie_uid', [Shortcode::getInstance(), 'shortcodeForCookieUID']);
            add_shortcode('borlabs_cookie_third_party', [Shortcode::getInstance(), 'shortcodeForCookieThirdParty']);
            add_shortcode('borlabs_cookie_first_party', [Shortcode::getInstance(), 'shortcodeForCookieFirstParty']);
            add_shortcode('borlabs_cookie_opt_out', [Shortcode::getInstance(), 'shortcodeForOptOut']);
            add_shortcode('borlabs_cookie_blocked_content', [ContentBlocker::getInstance(), 'handleShortcode']);

            // Deprecated, identical to borlabs_cookie_blocked_content
            add_shortcode('borlabs_cookie_blocked_oembed', [ContentBlocker::getInstance(), 'handleShortcode']);
        }
    }

    /**
     * loadTextdomain function.
     *
     * @access public
     * @return void
     */
    public function loadTextdomain()
    {
        load_plugin_textdomain('borlabs-cookie', false, dirname(BORLABS_COOKIE_SLUG).'/languages/');
    }

    /**
     * insertCookieMessageBox function.
     *
     * @access public
     * @return void
     */
    public function insertCookieMessageBox()
    {
        $testEnvironment = false;

        if (Config::getInstance()->get('testEnvironment') === true) {
            $testEnvironment = true;
        }

        $integration = 'script';

        if (Config::getInstance()->get('cookieBoxIntegration') === 'html') {
            $integration = 'html';
        }

        $position = 'bcPositionTop';

        if (Config::getInstance()->get('cookieBoxPosition') === 'bottom') {
            $position = 'bcPositionBottom';
        } elseif (Config::getInstance()->get('cookieBoxPosition') === 'center') {
            $position = 'bcPositionCenter';
        }

        $textExplanation = Config::getInstance()->get('textExplanation');

        $textExplanation = str_replace(
            [
                '%%privacy_url%%',
                '%%privacy_title%%',
                '%%imprint_url%%',
                '%%imprint_title%%',
            ],
            [
                Config::getInstance()->get('privacyPageURL'),
                Config::getInstance()->get('privacyPageTitle'),
                Config::getInstance()->get('imprintPageURL'),
                Config::getInstance()->get('imprintPageTitle'),
            ],
            $textExplanation
        );

        $textHelpBottom = Config::getInstance()->get('textHelpBottom');

        $textHelpBottom = str_replace(
            [
                '%%privacy_url%%',
                '%%privacy_title%%',
                '%%imprint_url%%',
                '%%imprint_title%%',
            ],
            [
                Config::getInstance()->get('privacyPageURL'),
                Config::getInstance()->get('privacyPageTitle'),
                Config::getInstance()->get('imprintPageURL'),
                Config::getInstance()->get('imprintPageTitle'),
            ],
            $textHelpBottom
        );

        $templatePath = realpath(dirname(__FILE__).'/../../../templates');
        $file = $templatePath.'/cookie-message-box.html';

        if (file_exists($file)) {
            include($file);
        }
    }
}
