<?php
/*
 * ----------------------------------------------------------------------
 *
 *                          Borlabs Cookie
 *                      developed by Borlabs
 *
 * ----------------------------------------------------------------------
 *
 * Copyright 2018 Borlabs - Benjamin A. Bornschein. All rights reserved.
 * This file may not be redistributed in whole or significant part.
 * Content of this file is protected by international copyright laws.
 *
 * ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 * @copyright Borlabs - Benjamin A. Bornschein, https://borlabs.io
 * @author Benjamin A. Bornschein, Borlabs ben@borlabs.io
 *
 */

namespace BorlabsCookie\Cookie\Backend;

class View
{
    private static $instance;

    private $imagePath;

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function __clone()
    {
    }

    private function __wakeup()
    {
    }

    protected function __construct()
    {
        $this->imagePath = plugins_url('images', realpath(__DIR__.'/../../'));
    }

    /**
     * __call function.
     *
     * @access public
     * @param mixed $class
     * @param mixed $args
     * @return void
     */
    public function __call($class, $args)
    {
        if (strpos($class, 'display__') !== false) {
            $this->displayHeader();

            $module = 'BorlabsCookie\Cookie\Backend\\'.substr($class, strpos($class, '__')+2);

            if (class_exists($module)) {
                $module::getInstance()->display();
            }

            $this->displayFooter();
        }
    }

    /**
     * displayHeader function.
     *
     * @access public
     * @return void
     */
    public function displayHeader()
    {
        include Backend::getInstance()->templatePath.'/header.html';
    }

    /**
     * displayFooter function.
     *
     * @access public
     * @return void
     */
    public function displayFooter()
    {
        include Backend::getInstance()->templatePath.'/footer.html';
    }
}
