<?php
/*
Plugin Name: Borlabs Cookie - Cookie Opt-in
Plugin URI: https://borlabs.io/
Description: Borlabs Cookie is an easy to use tool for WordPress that allows you to integrate JavaScripts that use cookies. The respective JavaScript is only activated and the is cookie set only once the visitor has opted in.
Author: Benjamin A. Bornschein, Borlabs
Author URI: https://borlabs.io
Version: 1.9.9
Text Domain: borlabs-cookie
Domain Path: /languages
*/

$borlabsCookieWPLANG = get_option('WPLANG', 'en_US');

if (empty($borlabsCookieWPLANG)) {
    $borlabsCookieWPLANG = 'en';
}

define('BORLABS_COOKIE_VERSION', '1.9.9');
define('BORLABS_COOKIE_SLUG', plugin_basename(__FILE__));
define('BORLABS_COOKIE_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('BORLABS_COOKIE_PLUGIN_URL', plugin_dir_url(__FILE__));
define('BORLABS_COOKIE_DEFAULT_LANGUAGE', substr($borlabsCookieWPLANG, 0, 2));

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

if (version_compare(phpversion(), '5.6', '>=')) {

    include_once plugin_dir_path(__FILE__).'classes/Autoloader.php';

    $Autoloader = new \BorlabsCookie\Autoloader();
    $Autoloader->register();
    $Autoloader->addNamespace('BorlabsCookie', realpath(plugin_dir_path(__FILE__).'/classes'));

    register_activation_hook(__FILE__, array(\BorlabsCookie\Cookie\Init::getInstance(), 'pluginActivated'));
    register_deactivation_hook(__FILE__, array(\BorlabsCookie\Cookie\Init::getInstance(), 'pluginDeactivated'));

    /* Init plugin */
    if (is_admin()) {
        /* Backend */
        \BorlabsCookie\Cookie\Init::getInstance()->initBackend();
    } else {
        /* Frontend */
        \BorlabsCookie\Cookie\Init::getInstance()->initFrontend();
    }

    /* Update */
    \BorlabsCookie\Cookie\Init::getInstance()->initUpdateHooks();

    /* Call after upgrade process is complete */
    add_action('upgrader_process_complete', array(\BorlabsCookie\Cookie\Update::getInstance(), 'upgradeComplete'), 10, 2);

    /* Third Party Developer Helper Class Shortcut Function - fun fact: in german this would be a single noun! */
    if (!function_exists('BorlabsCookieHelper')) {
        function BorlabsCookieHelper()
        {
            return \BorlabsCookie\Cookie\ThirdPartyHelper::getInstance();
        }
    }

} else {
    //! Fallback for very old php version
    add_action('admin_notices', function () {
    ?>
    <div class="notice notice-error">
        <p><?php _ex('Your PHP version is <a href="http://php.net/supported-versions.php" rel="noreferrer" target="_blank">outdated</a> and not supported by Borlabs Cookie. Please disable Borlabs Cookie, upgrade to PHP 5.6 or higher, and enable Borlabs Cookie again. It is necessary to follow these steps in the exact order described.', 'Status message', 'borlabs-cookie'); ?></p>
    </div>
    <?php
    });
}
?>